(* ::Package:: *)

(************************************************************************)
(* This file was generated automatically by the Mathematica front end.  *)
(* It contains Initialization cells from a Notebook file, which         *)
(* typically will have the same name as this file except ending in      *)
(* ".nb" instead of ".m".                                               *)
(*                                                                      *)
(* This file is intended to be loaded into the Mathematica kernel using *)
(* the package loading commands Get or Needs.  Doing so is equivalent   *)
(* to using the Evaluate Initialization Cells menu command in the front *)
(* end.                                                                 *)
(*                                                                      *)
(* DO NOT EDIT THIS FILE.  This entire file is regenerated              *)
(* automatically each time the parent Notebook file is saved in the     *)
(* Mathematica front end.  Any changes you make to this file will be    *)
(* overwritten.                                                         *)
(************************************************************************)



(* ::Input::Initialization:: *)
generateBasis[ns_,specialList_]:=Module[{bb1,bb2,bb3,bb4},
bb1=Tuples[{0,1},2ns];
bb2={#[[1;;;;2]],#[[2;;;;2]]}&/@bb1;

(* restrict to the 1-qp subspace, if needed *)
bb3=bb2;
Do[
bb3=Select[bb2,Total[#[[All,specialList[[i]]]]]<=1&];
,{i,Length[specialList]}];

bb3=Sort[bb3]; (* We never use bb4, so no point in computing it *)
Return[bb3]; 
];


(* ::Input::Initialization:: *)
(* Step 2a: Construct the on-site Hamiltonian *)
constructHsite[bb3_, \[Epsilon]Upm_, \[Epsilon]Downm_]:=Module[{HPE},
HPE=Table[{i,i}->(bb3[[i,1]].\[Epsilon]Upm+bb3[[i,2]].\[Epsilon]Downm),{i,Length[bb3]}];
Return[HPE];
];

(* Step 2b: Construct the interaction Hamiltonian *)
constructHinteractions[bb3_, Um_]:=Module[{HPE,ns},
ns=Length[Um];
HPE=Table[{i,i}->(
(bb3[[i,1]]*bb3[[i,2]]).Diagonal[Um]
+Sum[Sum[Um[[s1,s2]]*(bb3[[i,1,s1]]+bb3[[i,2,s1]])*(bb3[[i,1,s2]]+bb3[[i,2,s2]]),{s2,1,s1-1}],{s1,2,ns}]
),{i,Length[bb3]}];
Return[HPE];
];

(* Step 2c: Construct the Hamiltonian for the cost of electrons in the leads *)
constructHCP[bb3_,Vleads_]:=Module[{shift1, shift2, HPE,ns},
ns=Length[Vleads];
HPE=Table[{i,i}->Sum[(1-bb3[[i,\[Sigma],s]])Vleads[[s]],{\[Sigma],2},{s,ns}],{i,Length[bb3]}];
Return[HPE];
];


(* ::Input::Initialization:: *)
computeSign[vec_, s_]:=Module[{sign},
sign=Total[vec[[1]]]+Total[vec[[1,;;s]]]+Total[vec[[2,;;s]]];
Return[(-1)^sign];
];


(* ::Input::Initialization:: *)
(* Anrdeev reflection from each of the sites *)
constructHAndreev[bb3_,\[CapitalDelta]list_]:=Module[{HKE2,res,i,j,s},
HKE2=Table[
Sum[
res=0;
If[((Delete[#,s]&/@bb3[[i]])==(Delete[#,s]&/@bb3[[j]])),
If[(Total[bb3[[i,All,s]]]==2)&&(Total[bb3[[j,All,s]]]==0),res=\[CapitalDelta]list[[s]]*computeSign[bb3[[j]],s] ];
If[(Total[bb3[[i,All,s]]]==0)&&(Total[bb3[[j,All,s]]]==2),res=Conjugate[\[CapitalDelta]list[[s]]]*computeSign[bb3[[i]],s] ];
];
res
,{s, Length[\[CapitalDelta]list]}]
,{i,Length[bb3]},{j,Length[bb3]}];
Return[HKE2];
];


(* ::Input::Initialization:: *)
constructTotalSpin[bb3_]:=Module[{},
Return[Table[{i,i}->(Total[bb3[[i,1]]]-Total[bb3[[i,2]]]),{i,Length[bb3]}]];
];

constructParity[bb3_]:=Module[{},
Return[Table[{i,i}->If[OddQ[(Total[bb3[[i,1]]]+Total[bb3[[i,2]]])],1,0],{i,Length[bb3]}]];
];

constructNumber[bb3_]:=Module[{ns},
ns=Length[bb3[[1,1]]];
Return[
Table[
SparseArray[Table[{i,i}->(bb3[[i,1,k]]+bb3[[i,2,k]]),{i,Length[bb3]}]]
,{k,ns}]
];
];

constructRaisingLowering[bb3_]:=Module[{ns, index, dDaggerM, dDagger, sign, psiInitial, psiFinal, l,d,site, \[Sigma]},
(* output of this function is a list of raising and lowering operators organized by [[spin,site]] *)
ns=Length[bb3[[1,1]]];
l=Length[bb3];
index=<|#[[1]]->#[[2]]&/@Transpose[{bb3,Range[Length[bb3]]}]|>; (* generate an association to quickly search the basis for position of its elements *)

dDaggerM=Table[{},{\[Sigma],2},{site,ns}];
Do[
psiInitial=bb3[[i]];

Do[
If[psiInitial[[\[Sigma],site]]==0,
psiFinal=psiInitial;
psiFinal[[\[Sigma],site]]=1;

(* count the number of operators to the left of the creation operator to get the sign correct *)
(*Print["Computing sign \[Sigma]=",\[Sigma],"  site=",site];*)
If[\[Sigma]==1,
sign=Total[psiInitial[[1,;;site]]];
,
sign=Total[psiInitial[[1]]]+Total[psiInitial[[2,;;site]]];
];
(*Print[sign];*)
AppendTo[dDaggerM[[\[Sigma],site]],{Lookup[index, {psiInitial}][[1]],Lookup[index, {psiFinal}][[1]]}->(-1)^sign];
];
,{\[Sigma],2},{site,ns}];
,{i,Length[bb3]}];

dDagger=Table[
SparseArray[dDaggerM[[\[Sigma],site]],{l,l}]
,
{\[Sigma],2},{site,ns}];

d=Table[
Transpose[dDagger[[\[Sigma],site]]]
,
{\[Sigma],2},{site,ns}];

Return[{dDagger,d}];
];


(* ::Input::Initialization:: *)
constructRaisingLoweringPartial[bb3_]:=Module[{ns, index, dDaggerM, dDagger, sign, psiInitial, psiFinal, l,d, \[Sigma], site,b,a},
(* output of this function is a list of raising and lowering operators organized by [[spin,site]] *)
ns=Length[bb3[[1,1]]];
l=Length[bb3];
index=<|#[[1]]->#[[2]]&/@Transpose[{bb3,Range[Length[bb3]]}]|>; (* generate an association to quickly search the basis for position of its elements *)

dDaggerM=Table[{},{\[Sigma],2},{site,ns}];
Do[
psiInitial=bb3[[i]];

Do[
If[psiInitial[[\[Sigma],site]]==0,
psiFinal=psiInitial;
psiFinal[[\[Sigma],site]]=1;

(* count the number of operators to the left of the creation operator to get the sign correct *)
(*Print["Computing sign \[Sigma]=",\[Sigma],"  site=",site];*)
If[\[Sigma]==1,
sign=Total[psiInitial[[1,;;site]]];
,
sign=Total[psiInitial[[1]]]+Total[psiInitial[[2,;;site]]];
];
(*Print[sign];*)
a=Lookup[index, {psiInitial}][[1]];
b=Lookup[index, {psiFinal}][[1]];
If[NumberQ[a]&&NumberQ[b],
AppendTo[dDaggerM[[\[Sigma],site]], {b,a}->(-1)^sign];
];
];
,{\[Sigma],2},{site,ns}];
,{i,Length[bb3]}];

dDagger=Table[
SparseArray[dDaggerM[[\[Sigma],site]],{l,l}]
,
{\[Sigma],2},{site,ns}];

d=Table[
Transpose[dDagger[[\[Sigma],site]]]
,
{\[Sigma],2},{site,ns}];

Return[{dDagger,d}];
];


(* ::Input::Initialization:: *)
generateElasticME[states_,gammaMatrix1_,d_,dDagger_]:=Module[{\[Sigma]1,s1,i},
Table[
{\[Sigma]1,s1}=gammaMatrix1[[i,1]];
Abs[states[[All,2]].(d[[\[Sigma]1,s1]]+dDagger[[\[Sigma]1,s1]]).Transpose[states[[All,2]]]]^2
,{i, Length[gammaMatrix1]}]
];


(* ::Input::Initialization:: *)
generateInelasticME[states_,gammaMatrix2_,d_,dDagger_]:=Module[{\[Sigma]1,s1,\[Sigma]2,s2,i},
Table[
{{\[Sigma]1,s1},{\[Sigma]2,s2}}=gammaMatrix2[[i,1;;2]];
Abs[states[[All,2]].dDagger[[\[Sigma]1,s1]].d[[\[Sigma]2,s2]].Transpose[states[[All,2]]]]^2
,{i, Length[gammaMatrix2]}]
];


(* ::Input::Initialization:: *)
(* This set of functions takes care of accounting for the energy of electrons in the leads when we perform inter-dot tunneling *)
generateInelasticTransitionRates[bb3_, VSD_, states_,gammaMatrix2_,iME_]:=Module[{res,\[CapitalDelta]E,i,\[Alpha],\[Beta]},
(* we want to generate the transition rate \[Alpha]\[Rule]\[Beta]. The main hurdle to overcome is the energy shifts, as we already have the matrix elements... *)
Table[
Sum[
If[iME[[i, \[Beta], \[Alpha]]]!=0,
\[CapitalDelta]E=states[[\[Alpha],1]]-states[[\[Beta],1]]+VSD[[gammaMatrix2[[i,2,2]]]]-VSD[[gammaMatrix2[[i,1,2]]]];
iME[[i, \[Beta], \[Alpha]]]*Abs[gammaMatrix2[[i,3]]]*pStep[\[CapitalDelta]E]
,0]
,{i, Length[gammaMatrix2]}]
,{\[Alpha],Length[states]},{\[Beta],Length[states]}]
]


(* ::Input::Initialization:: *)
(* this function computes the inelastic transition rates *)
generateElasticTransitionRates[states_,gammaMatrix1_,eME_, tInv_]:=Module[{res,\[Alpha],\[Beta]},
(* we want to generate the transition rate \[Alpha]\[Rule]\[Beta]. The main hurdle to overcome is the energy shifts, as we already have the matrix elements... 
Make sure the sign of the step function is OK
*)
Table[
Sum[
If[eME[[i, \[Beta], \[Alpha]]]!=0,
(eME[[i, \[Beta], \[Alpha]]])*gammaMatrix1[[i,2]]*nF[-(states[[\[Alpha],1]]-states[[\[Beta],1]]),tInv]
,0]
,{i, Length[gammaMatrix1]}]
,{\[Alpha],Length[states]},{\[Beta],Length[states]}]
]


(* ::Input::Initialization:: *)
(* this function computes the inelastic transition rates *)
generateInelasticCurrent[bb3_, VSD_, states_,gammaMatrix2_,iME_]:=Module[{res,\[CapitalDelta]E,i,\[Alpha],\[Beta]},
(* we want to generate the transition rate \[Alpha]\[Rule]\[Beta]. The main hurdle to overcome is the energy shifts, as we already have the matrix elements... *)
Table[
Sum[
If[iME[[i, \[Beta], \[Alpha]]]!=0,
\[CapitalDelta]E=states[[\[Alpha],1]]-states[[\[Beta],1]]+VSD[[gammaMatrix2[[i,2,2]]]]-VSD[[gammaMatrix2[[i,1,2]]]];
iME[[i, \[Beta], \[Alpha]]]*gammaMatrix2[[i,3]]*pStep[\[CapitalDelta]E]
,
0
]
,{i, Length[gammaMatrix2]}]
,{\[Alpha],Length[states]},{\[Beta],Length[states]}]
]


(* ::Input::Initialization:: *)
computeCurrent[bb3_, gate_, Um_, VSD_, \[CapitalDelta]SD_,gammaMatrix1_, gammaMatrix2_,\[Beta]_]:=Module[{H, HA, states, st, eME, iME, Tem, Tim, Jim, Ttot, es0, es, jt,dDagger, d, p},
H=SparseArray[constructHsite[bb3, gate[[1]],gate[[2]]]]+SparseArray[constructHinteractions[bb3, Um]]+SparseArray[constructHCP[bb3,VSD]];
HA=constructHAndreev[bb3,\[CapitalDelta]SD];

states=Chop[Sort[Transpose[Eigensystem[H+HA]]]];
st={#[[1]],bb3[[Ordering[Abs[#[[2]]],-1][[1]]]]}&/@states;

{dDagger,d}=constructRaisingLoweringPartial[bb3];

eME=generateElasticME[states, gammaMatrix1,d,dDagger];
iME=generateInelasticME[states, gammaMatrix2,d,dDagger];

Tem=generateElasticTransitionRates[states, gammaMatrix1, eME,\[Beta]];
Tim=generateInelasticTransitionRates[bb3, VSD, states, gammaMatrix2, iME];
Jim=Transpose[Chop[generateInelasticCurrent[bb3, VSD, states, gammaMatrix2, iME]]];

Ttot=Chop[Transpose[Tem]+Transpose[Tim]];
Do[
Ttot[[i,i]]=-Total[Ttot[[All,i]]];
,{i, Length[Ttot]}];
es0=Sort[Transpose[Eigensystem[Ttot]]];
es={es0[[-1]]};
(*es=Select[es0, #[[1]]\[Equal]0&];*)
jt=Table[
p=es[[k,2]]/Total[es[[k,2]]];
Total[Jim.p]
,{k,Length[es]}];
Return[{jt[[Ordering[Abs[jt],-1][[1]]]](*,jt,Select[es0, #[[1]]\[Equal]0&]*)}];
(*
If[Length[es]>1, Return[0]];
p=es[[1,2]]/Total[es[[1,2]]];
If[Length[Select[p,#>0&]]\[Equal]1, Return[0]];

Return[Total[Transpose[Jim].p]];*)
];


(* ::Input::Initialization:: *)
computeCurrentProfile[bb3_, gate_, Um_, VSD_, \[CapitalDelta]SD_,gammaMatrix1_, gammaMatrix2_,\[Beta]_]:=Module[{H, HA, states, st, eME, iME, Tem, Tim, Jim, Ttot, es0, es, jt,dDagger, d, p},
t1=AbsoluteTiming[H=SparseArray[constructHsite[bb3, gate[[1]],gate[[2]]]]+SparseArray[constructHinteractions[bb3, Um]]+SparseArray[constructHCP[bb3,VSD]];
][[1]];
t2=AbsoluteTiming[HA=constructHAndreev[bb3,\[CapitalDelta]SD];][[1]];

t3=AbsoluteTiming[states=Chop[Sort[Transpose[Eigensystem[H+HA]]]];][[1]];
t4=AbsoluteTiming[st={#[[1]],bb3[[Ordering[Abs[#[[2]]],-1][[1]]]]}&/@states;][[1]];

t5=AbsoluteTiming[{dDagger,d}=constructRaisingLoweringPartial[bb3];][[1]];

t6=AbsoluteTiming[
eME=generateElasticME[states, gammaMatrix1];
iME=generateInelasticME[states, gammaMatrix2];
][[1]];

t7a=AbsoluteTiming[Tem=generateElasticTransitionRates[states, gammaMatrix1, eME,\[Beta]];][[1]];
t7b=AbsoluteTiming[Tim=generateInelasticTransitionRates[bb3, VSD, states, gammaMatrix2, iME];][[1]];
t7c=AbsoluteTiming[Jim=Transpose[Chop[generateInelasticCurrent[bb3, VSD, states, gammaMatrix2, iME]]];][[1]];

t8=AbsoluteTiming[
Ttot=Chop[Transpose[Tem]+Transpose[Tim]];
Do[
Ttot[[i,i]]=-Total[Ttot[[All,i]]];
,{i, Length[Ttot]}];
es0=Sort[Transpose[Eigensystem[Ttot]]];
es={es0[[-1]]};
][[1]];
(*es=Select[es0, #[[1]]\[Equal]0&];*)
jt=Table[
p=es[[k,2]]/Total[es[[k,2]]];
Total[Jim.p]
,{k,Length[es]}];
Return[{jt[[Ordering[Abs[jt],-1][[1]]]](*,jt,Select[es0, #[[1]]\[Equal]0&]*)}];
(*
If[Length[es]>1, Return[0]];
p=es[[1,2]]/Total[es[[1,2]]];
If[Length[Select[p,#>0&]]\[Equal]1, Return[0]];

Return[Total[Transpose[Jim].p]];*)
];


(* ::Input::Initialization:: *)
nF[x_,\[Beta]_]:=1/(E^(\[Beta] x)+1); 
pStep[x_]:=0.5(1+Tanh[20x]);
